% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-class.R
\name{intersection_df}
\alias{intersection_df}
\alias{intersection_df,Recipe-method}
\alias{intersection_df,PrepRecipe-method}
\title{Returns data.frame with OTU intersection between methods}
\usage{
intersection_df(rec, steps = steps_ids(rec, "da"), tidy = FALSE)

\S4method{intersection_df}{Recipe}(rec, steps = steps_ids(rec, "da"), tidy = FALSE)

\S4method{intersection_df}{PrepRecipe}(rec, steps = steps_ids(rec, "da"), tidy = FALSE)
}
\arguments{
\item{rec}{A \code{Recipe} object.}

\item{steps}{character vector with step_ids to take in account.}

\item{tidy}{Boolan indicating if result must be in tidy format.}
}
\value{
data.frame class object
}
\description{
Returns data.frame with OTU intersection between methods
}
\examples{
data(test_prep_rec)

df <- intersection_df(test_prep_rec)
head(df)

## intersection_df function needs a prep-Recipe. If you pass a a non-prep
## recipe the output is an error.
data(test_rec)
err <- testthat::expect_error(intersection_df(test_rec))
err
}
