% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetting-utils.R
\docType{methods}
\name{CytoImageList-subsetting}
\alias{CytoImageList-subsetting}
\alias{getImages}
\alias{getChannels}
\alias{mergeChannels}
\alias{setImages<-}
\alias{setChannels<-}
\alias{getImages,CytoImageList-method}
\alias{setImages<-,CytoImageList-method}
\alias{getChannels,CytoImageList-method}
\alias{setChannels<-,CytoImageList-method}
\alias{[<-,CytoImageList,ANY,ANY,CytoImageList-method}
\alias{[[<-,CytoImageList,ANY,ANY-method}
\title{General subsetting methods for CytoImageList objects}
\arguments{
\item{x, y}{\code{CytoImageList} objects}

\item{i}{integer, logical, character or vector of such indicating which
element(s) to replace or extract}

\item{value}{a \code{CytoImageList} or \code{\linkS4class{Image}}
object}
}
\value{
A CytoImageList object
}
\description{
These getter and setter functions are used to extract, replace and merge
entries in a \code{\linkS4class{CytoImageList}} object.
}
\section{Setting and getting images}{

Functions to extract and replace elements (= images) of a
\linkS4class{CytoImageList} object. In the following code, \code{x} is a
CytoImageList object. The parameter \code{i} indicates the element(s) of
\code{x} that should be returned or replaced. Replacement is done by
\code{value}, which takes a CytoImageList or Image object. If \code{length(i)
> 0}, \code{value} has to be a CytoImageList object of \code{length(i)},
otherwise \code{value} allows a CytoImageList object of length 1 or an Image
object. If an Image object is provided, only the image entry in the
CytoImageList object is replaced, not the corresponding elementMetadata
entry.

\describe{
\item{\code{getImages(x, i)}}{Returns image(s) indicated by \code{i} of
the CytoImageList object \code{x}}
\item{\code{setImages(x, i) <- value}}{Replaces the image(s) indicated by
\code{i} of the CytoImageList object \code{x} with \code{value}. For this,
\code{value} needs to have the same length as \code{i}}
}

These setter and getter functions are the recommended way of extracting and
replacing images in a CytoImageList object. Alternatively, the standard
operations via \code{`[`}, \code{`[[`}, \code{`[<-`} and \code{`[[<-`} can be
performed (see \code{?\link{List}} for S4Vectors subsetting functionality).
However, these operations do not change element names during replacment
calls. The \code{setImages()} function makes sure that element names are
replaced if \code{value} is named or if \code{i} is a character or vector of
characters.
}

\section{Getting and setting channels}{

Functions to extract and replace channels of a \linkS4class{CytoImageList}
object. Here, \code{x} is a \linkS4class{CytoImageList} object. The parameter
\code{i} indicates the channels of \code{x} that should be returned or
replaced. Replacement is done by \code{value}, which takes a CytoImageList
object. The CytoImageList object \code{value} needs to have the same length
as \code{x}. Furthermore, the number of channels in \code{value} should be
identical to \code{length(i)}.

\describe{
\item{\code{getChannels(x, i)}}{Returns channel(s) indicated by \code{i} of
the CytoImageList object \code{x}}
\item{\code{setChannels(x, i) <- value}}{Replaces the channel(s) indicated
by \code{i} of the CytoImageList object \code{x} with \code{value}. For this,
\code{value} needs to have the same length as \code{i} and the same
number of channels as \code{length(i)}.}
}

The \code{setChannels()} setter function does not allow adding new channels
to the CytoImageList object. For this operation, the \code{mergeChannels}
function was implemented (see below).
}

\section{Merging images}{

Merging images is possible by merging two or more CytoImageList objects via:

\describe{
\item{\code{c(x, y)}}{Returns an composite CytoImageList object with
elements of both CytoImageList objects \code{x} and \code{y}.
More than two CytoImageList objects can be merged in that way.}
}
}

\section{Merging channels}{

Merging channels is possible via:

\describe{
\item{\code{mergeChannels(x, y, h5FilesPath = NULL)}:}{
Returns a CytoImageList in which the channels of the CytoImageList object
\code{y} have been appended to the channels of the CytoImageList object
\code{x}. Only channels of two CytoImageList objects can be merged in that
way. The \code{h5FilesPath} argument can be ignored unless images are stored 
on disk. To avoid overriding the .h5 files, one needs to specify a new
location where the merged images are stored on disk. 
}
}
}

\examples{
data("pancreasImages")

# Get images
getImages(pancreasImages, 1)
getImages(pancreasImages, "E34_imc")
getImages(pancreasImages, 1:2)
getImages(pancreasImages, c("E34_imc", "G01_imc"))
getImages(pancreasImages, grepl("E34_imc", names(pancreasImages)))

# Set images
setImages(pancreasImages, 1) <- pancreasImages[1]
setImages(pancreasImages, "J02_imc") <- pancreasImages[1]
setImages(pancreasImages, "J02_imc") <- NULL

# Get channels
getChannels(pancreasImages, 1)
getChannels(pancreasImages, "CD99")
getChannels(pancreasImages, c("CD99", "PIN"))

# Set channels
channel1 <- getChannels(pancreasImages, 1)
setChannels(pancreasImages, 1) <- channel1
channelPIN <- getChannels(pancreasImages, "PIN")
setChannels(pancreasImages, "CD8a") <- channelPIN
setChannels(pancreasImages, "CD8a") <- NULL

# Merge images
data("pancreasImages")
c(pancreasImages[c(1,3)], pancreasImages[2])

# Merge channels
channel12 <- getChannels(pancreasImages, c(1,2))
channel34 <- getChannels(pancreasImages, c(3,4))
mergeChannels(channel12, channel34)

# Merge channels on disk
cur_images <- CytoImageList(pancreasImages,
                     on_disk = TRUE, 
                     h5FilesPath = HDF5Array::getHDF5DumpDir())
channel12 <- getChannels(cur_images, c(1,2))
channel34 <- getChannels(cur_images, c(3,4))

# This will overwrite the initial .h5 files
mergeChannels(channel12, channel34,
                h5FilesPath = HDF5Array::getHDF5DumpDir())

}
\author{
Nils Eling (\email{nils.eling@dqbm.uzh.ch})
}
