% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phytoFilterClass.R
\name{summaries,PhytopFilter-method}
\alias{summaries,PhytopFilter-method}
\title{takes a flowframes, a vector of channels, cluster indicator and return 
desired summaries per cluster}
\usage{
\S4method{summaries}{PhytopFilter}(
  object,
  channels = NULL,
  cluster_var = "Clusters",
  summary = c("mean", "median", "cov", "n")
)
}
\arguments{
\item{object}{An object of class cyanoFilter to be summarised.}

\item{channels}{channels whose summaries are to be computed}

\item{cluster_var}{column name in expression matrix containing the cluter 
indicators}

\item{summary}{summary statistic of interest. Only mean and 
variance-covariance matrix supported at the moment.}
}
\value{
list containing computed summaires
}
\description{
takes a flowframes, a vector of channels, cluster indicator and return 
desired summaries per cluster
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
              package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
c('SSC.W', 'TIME'))
cells_nonmargin <- cellMargin(flowframe = flowfile_logtrans, 
Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
cells_nodebris <- debrisNc(flowframe = reducedFlowframe(cells_nonmargin),
                           ch_chlorophyll = "RED.B.HLin",
                            ch_p2 = "YEL.B.HLin",
                            ph = 0.05)
fin <- phytoFilter(flowfile = reducedFlowframe(cells_nodebris),
              pig_channels = c("RED.B.HLin", "YEL.B.HLin", "RED.R.HLin"),
              com_channels = c("FSC.HLin", "SSC.HLin"))

summaries(object = fin,
        channels = c("RED.B.HLin", "YEL.B.HLin", "RED.R.HLin"),
        cluster_var = "Clusters",
        summary = 'mean')

}
