% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{pairsPlot}
\alias{pairsPlot}
\title{produces a scatter plot of the expression matrix of a flowframe. Note that, 
it takes some time to display the plot.}
\usage{
pairsPlot(x, notToPlot = c("TIME"), ...)
}
\arguments{
\item{x}{flowframe to be plotted}

\item{notToPlot}{column in expression matrix not to be plotted}

\item{...}{other arguments. Not used at the moment}
}
\value{
a plot object
}
\description{
produces a scatter plot of the expression matrix of a flowframe. Note that, 
it takes some time to display the plot.
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
              package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
                      c('SSC.W', 'TIME'))
pairsPlot(flowfile_logtrans,
           notToPlot = c("TIME", "SSC.W",
           "SSC.HLin", "NIR.R.HLin", 
           "FSC.HLin"))  
           
}
