% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phytoFilterClass.R
\name{fullFlowframe,MarginEvents-method}
\alias{fullFlowframe,MarginEvents-method}
\title{accesor method for the fullflowframe (MarginEvent class)}
\usage{
\S4method{fullFlowframe}{MarginEvents}(x)
}
\arguments{
\item{x}{an object of class MarginEvents}
}
\value{
full Flowframe method for MarginEvents
}
\description{
accesor method for the fullflowframe (MarginEvent class)
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                  package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
c('SSC.W', 'TIME'))
cells_nonmargin <- cellMargin(flowframe = flowfile_logtrans, 
Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
fullFlowframe(cells_nonmargin)
}
