% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phytoFilterClass.R
\name{DebrisFilter}
\alias{DebrisFilter}
\title{the Debris class}
\usage{
DebrisFilter(
  fullflowframe,
  reducedflowframe,
  deb_pos,
  syn_all_pos,
  deb_cut,
  ch_chlorophyll,
  ch_p2
)

DebrisFilter(
  fullflowframe,
  reducedflowframe,
  deb_pos,
  syn_all_pos,
  deb_cut,
  ch_chlorophyll,
  ch_p2
)
}
\arguments{
\item{fullflowframe}{same as the input flowFrame}

\item{reducedflowframe}{a partial flowframe containing non-margin events}

\item{deb_pos}{number of margin particles measured}

\item{syn_all_pos}{number of non-margine particles}

\item{deb_cut}{estimated inflection point between debris and good cells}

\item{ch_chlorophyll}{channel estimating chlorophyll level}

\item{ch_p2}{plotting channel}
}
\value{
object of class DebrisFilter
}
\description{
the Debris class

constructor for the DebrisFilter class
}
\section{Slots}{

\describe{
\item{\code{fullflowframe}}{object of class "flowFrame" same as the input flowFrame}

\item{\code{reducedflowframe}}{object of class "flowFrame" a partial flowframe 
containing a proportion of the measured particles}

\item{\code{deb_pos}}{object of class "numeric" representing the 
proportion of particles in each cluster}

\item{\code{syn_all_pos}}{object of class "numeric" representing the 
number of particles in each cluster}

\item{\code{deb_cut}}{object of class "numeric" representing the inflection point
between debris and good cells.}

\item{\code{ch_chlorophyll}}{objet of class "character" representing the chlorophyll
channel.}

\item{\code{ch_p2}}{object of class character to plot}
}}

