% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crumblr.R
\name{clrInv}
\alias{clrInv}
\title{Inverse of Centered log ratio transform}
\usage{
clrInv(x)
}
\arguments{
\item{x}{CLR transform values}
}
\value{
matrix of fractions
}
\description{
Compute the inverse centered log ratio (CLR) transform of a count matrix.
}
\details{
Given the CLR transformed values, compute the original fractions
}
\examples{
# set probability of each category
prob <- c(0.1, 0.2, 0.3, 0.5)

# number of total counts
countsTotal <- 300

# number of samples
n_samples <- 5

# simulate info for each sample
info <- data.frame(Age = rgamma(n_samples, 50, 1))
rownames(info) <- paste0("sample_", 1:n_samples)

# simulate counts from multinomial
counts <- t(rmultinom(n_samples, size = countsTotal, prob = prob))
colnames(counts) <- paste0("cat_", 1:length(prob))
rownames(counts) <- paste0("sample_", 1:n_samples)

# Fractions
counts / rowSums(counts)

# centered log ratio, with zero pseudocount
clr(counts, 0)

# recover fractions from CLR transformed values
clrInv(clr(counts, 0))

}
\references{
Van den Boogaart, K. Gerald, and Raimon Tolosana-Delgado. Analyzing compositional data with R. Vol. 122. Berlin: Springer, 2013.
}
\seealso{
\code{compositions::clrInv()}
}
