% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crisprUI.R
\name{crisprUI}
\alias{crisprUI}
\title{UI component for crisprShiny App}
\usage{
crisprUI(id, cssFile = NULL)
}
\arguments{
\item{id}{Module ID.}

\item{cssFile}{Optional path of CSS file to be included in rendering app.
\code{NULL} gives default styling, found in \code{inst/www/styling.css}.}
}
\value{
Shiny module UI component.
}
\description{
UI component for crisprShiny App. Not intended for direct use.
}
\examples{
library(crisprShiny)
ui <- function(id){
    fluidPage(
        crisprUI(id)
    )
}

server <- function(id, gs){
    function(input, output, session){
        observeEvent(gs, {
            crisprServer(
                id,
                guideSet=gs,
                geneModel=NULL,
                useFilterPresets=TRUE
            )
        })
    }
}

myApp <- function(gs){
    shinyApp(ui=ui("id"), server=server("id", gs))
}

if (interactive()){
    data("guideSetExample_basic", package="crisprShiny")
    myApp(guideSetExample_basic)
}

}
