% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addPfamDomains.R
\name{addPfamDomains}
\alias{addPfamDomains}
\alias{addPfamDomains,GuideSet-method}
\alias{addPfamDomains,PairedGuideSet-method}
\alias{addPfamDomains,NULL-method}
\title{Add Pfam domains annotation to \linkS4class{GuideSet} object}
\usage{
addPfamDomains(object, ...)

\S4method{addPfamDomains}{GuideSet}(object, pfamTable)

\S4method{addPfamDomains}{PairedGuideSet}(object, pfamTable)

\S4method{addPfamDomains}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{pfamTable}{A \linkS4class{DataFrame} obtained using
\code{\link{preparePfamTable}}.}
}
\value{
An updated object with a colum \code{pfam} added to
    \code{geneAnnotation(object)}.
}
\description{
Add Pfam domains annotation to \linkS4class{GuideSet} object.
}
\details{
In order to call this function,
    the \code{object} must contain a gene annotation
    by calling first \code{\link{addGeneAnnotation}}.
}
\seealso{
See \code{\link{preparePfamTable}} to prepare the Pfam
    domain DataFrame object, and see \code{\link{addGeneAnnotation}}
    to add a gene annotation to the \code{object}.
}
\author{
Jean-Philippe Fortin
}
