% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaseEditor-class.R
\name{plotEditingWeights}
\alias{plotEditingWeights}
\title{Quick plot to visualize editing weights}
\usage{
plotEditingWeights(
  baseEditor,
  discardEmptyRows = TRUE,
  substitutions = NULL,
  ylim = c(0, 1),
  ...
)
}
\arguments{
\item{baseEditor}{A \code{\linkS4class{BaseEditor}} object.}

\item{discardEmptyRows}{Should rows that have all weight equal
to 0 be discarded? TRUE by default.}

\item{substitutions}{Character vector specifying substitutions
to be plotted. If NULL (default), all substitutions are shown.}

\item{ylim}{Vector of length 2 specifying the y plot limits.}

\item{...}{Additional arguments to be passed to \code{plot}}
}
\value{
Nothing. A plot is generated as a side effect.
}
\description{
Quick plot to visualize editing weights from a 
BaseEditor object.
}
\examples{
if (interactive()){
    data(BE4max, package="crisprBase")
    plotEditingWeights(BE4max)
}
}
