% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetics.R
\name{getEditingSiteFromPamSite}
\alias{getEditingSiteFromPamSite}
\title{Return optimal editing site coordinates from PAM site coordinates}
\usage{
getEditingSiteFromPamSite(
  pam_site,
  strand,
  baseEditor = NULL,
  substitution = NULL
)
}
\arguments{
\item{pam_site}{Coordinate of the first nucleotide of the PAM sequence.}

\item{strand}{Either "+" or "-".}

\item{baseEditor}{A \linkS4class{BaseEditor} object.}

\item{substitution}{String indicating which substitution
should be used to estimate the optimal editing position. 
E.g. "C2T" will return the optimal editing position for C to T
editing.}
}
\value{
numeric vector of editing sites.
}
\description{
Return optimal editing site coordinates from PAM 
    site coordinates.
}
\examples{
data(BE4max, package="crisprBase")
getEditingSiteFromPamSite(pam_site=100, strand="+", baseEditor=BE4max, "C2T")

}
\author{
Jean-Philippe Fortin
}
