% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetics.R
\name{getCutSiteFromPamSite}
\alias{getCutSiteFromPamSite}
\title{Return cut site coordinates from PAM site coordinates}
\usage{
getCutSiteFromPamSite(pam_site, strand, nuclease = NULL)
}
\arguments{
\item{pam_site}{Coordinate of the first nucleotide of the PAM sequence.}

\item{strand}{Either "+" or "-".}

\item{nuclease}{A \linkS4class{CrisprNuclease} object.}
}
\value{
numeric vector of cut sites
}
\description{
Return cut site coordinates from PAM site coordinates.
}
\examples{
data(SpCas9, package="crisprBase")
getCutSiteFromPamSite(pam_site=100, strand="+", nuclease=SpCas9)
getCutSiteFromPamSite(pam_site=100, strand="-", nuclease=SpCas9)

}
\author{
Jean-Philippe Fortin
}
