% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetics.R
\name{extractProtospacerFromTarget}
\alias{extractProtospacerFromTarget}
\title{Extract protospacer sequences from target sequences}
\usage{
extractProtospacerFromTarget(targets, object)
}
\arguments{
\item{targets}{Character vector of targets sequences.}

\item{object}{\code{CrisprNuclease} corresponding to the targets 
sequences.}
}
\value{
Character vector of protospacer sequences of 
    length equal to that of the 
    \code{targets} character vector.
}
\description{
Extract protospacer sequences from target sequences
    (protospacer + PAM) using information stored in a
    CrisprNuclease object.
}
\examples{
data(SpCas9, AsCas12a, package="crisprBase")
# Extracting protospacer sequences from Cas9 targets:
targets <- c("AGGTGCTGATTGTAGTGCTGCGG",
             "AGGTGCTGATTGTAGTGCTGAGG")
extractProtospacerFromTarget(targets, SpCas9)
# Extracting protospacer sequences from Cas12a targets:
targets <- c("TTTAAGGTGCTGATTGTAGTGCTGTGT",
             "TTTCAGGTGCTGATTGTAGTGCTGAAA")
extractProtospacerFromTarget(targets, AsCas12a)

}
\author{
Jean-Philippe Fortin
}
