% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetics.R
\name{extractPamFromTarget}
\alias{extractPamFromTarget}
\title{Extract PAM sequences from target sequences}
\usage{
extractPamFromTarget(targets, object)
}
\arguments{
\item{targets}{Character vector of target sequences.}

\item{object}{\code{CrisprNuclease} corresponding to the target 
sequences.}
}
\value{
Character vector of PAM sequences of length equal to that of the 
    \code{targets} character vector.
}
\description{
Extract PAM sequences from target sequences
    (protospacer + PAM) using information stored in a
    CrisprNuclease object.
}
\examples{
data(SpCas9, AsCas12a, package="crisprBase")
# Extracting PAM sequences from Cas9 protospacers:
targets <- c("AGGTGCTGATTGTAGTGCTGCGG",
              "AGGTGCTGATTGTAGTGCTGAGG")
extractPamFromTarget(targets, SpCas9)
# Extracting PAM sequences from Cas12a targets:
targets <- c("TTTAAGGTGCTGATTGTAGTGCTGTGT",
             "TTTCAGGTGCTGATTGTAGTGCTGAAA")
extractPamFromTarget(targets, AsCas12a)

}
\author{
Jean-Philippe Fortin
}
