% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-AllGenerics.R, R/methods.R
\docType{methods}
\name{coseq}
\alias{coseq}
\alias{coseq,matrix-method}
\alias{coseq-methods}
\alias{coseq,data.frame-method}
\alias{coseq,DESeqDataSet-method}
\title{Co-expression or co-abudance analysis of high-throughput sequencing data}
\usage{
coseq(object, ...)

\S4method{coseq}{matrix}(
  object,
  K,
  subset = NULL,
  model = "kmeans",
  transformation = "logclr",
  normFactors = "TMM",
  meanFilterCutoff = NULL,
  modelChoice = ifelse(model == "kmeans", "DDSE", "ICL"),
  parallel = FALSE,
  BPPARAM = bpparam(),
  seed = NULL,
  ...
)

\S4method{coseq}{data.frame}(
  object,
  K,
  subset = NULL,
  model = "kmeans",
  transformation = "logclr",
  normFactors = "TMM",
  meanFilterCutoff = NULL,
  modelChoice = ifelse(model == "kmeans", "DDSE", "ICL"),
  parallel = FALSE,
  BPPARAM = bpparam(),
  seed = NULL,
  ...
)

\S4method{coseq}{DESeqDataSet}(
  object,
  K,
  model = "kmeans",
  transformation = "logclr",
  normFactors = "TMM",
  meanFilterCutoff = NULL,
  modelChoice = ifelse(model == "kmeans", "DDSE", "ICL"),
  parallel = FALSE,
  BPPARAM = bpparam(),
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{Data to be clustered. May be provided as a y (\emph{n} x \emph{q})
matrix or data.frame of observed counts for \emph{n}
observations and \emph{q} variables, or an object of class \code{DESeqDataSet}
arising from a differential analysis via DESeq2.}

\item{...}{Additional optional parameters.}

\item{K}{Number of clusters (a single value or a vector of values)}

\item{subset}{Optional vector providing the indices of a subset of
genes that should be used for the co-expression analysis (i.e., row indices
of the data matrix \code{y}. For the generic function \code{coseq}, the results of a previously
run differential analysis may be used to select a subset of genes on which to perform the
co-expression analysis. If this is desired, \code{subset.index} can also be an object of class
DESeqResults (from the \code{results} function in \code{DESeq2}).}

\item{model}{Type of mixture model to use (\dQuote{\code{Poisson}} or \dQuote{\code{Normal}}), or alternatively
\dQuote{\code{kmeans}} for a K-means algorithm}

\item{transformation}{Transformation type to be used: \dQuote{\code{voom}}, \dQuote{\code{logRPKM}}
(if \code{geneLength} is provided by user), \dQuote{\code{arcsin}}, \dQuote{\code{logit}},
\dQuote{\code{logMedianRef}}, \dQuote{\code{profile}}, \dQuote{\code{logclr}}, \dQuote{\code{clr}},
\dQuote{\code{alr}}, \dQuote{\code{ilr}}, or \dQuote{\code{none}}}

\item{normFactors}{The type of estimator to be used to normalize for differences in
library size: (\dQuote{\code{TC}} for total count, \dQuote{\code{UQ}} for
upper quantile, \dQuote{\code{Med}} for median, \dQuote{\code{DESeq}} for
the normalization method in the DESeq package, and \dQuote{\code{TMM}} for
the TMM normalization method (Robinson and Oshlack, 2010). Can also be a
vector (of length \emph{q}) containing pre-estimated library size estimates
for each sample, or \dQuote{\code{none}} if no normalization is required.}

\item{meanFilterCutoff}{Value used to filter low mean normalized counts if desired (by default,
set to a value of 50)}

\item{modelChoice}{Criterion used to select the best model. For Gaussian mixture models,
\dQuote{\code{ICL}} (integrated completed likelihood criterion) is currently supported. For Poisson
mixture models, \dQuote{\code{ICL}}, \dQuote{\code{BIC}} (Bayesian information criterion), and a
non-asymptotic criterion calibrated via the slope heuristics  using either the \dQuote{\code{DDSE}}
(data-driven slope estimation) or \dQuote{\code{Djump}} (dimension jump) approaches may be used.
See the \code{HTSCluster} package documentation for more details about the slope heuristics approaches.}

\item{parallel}{If \code{FALSE}, no parallelization. If \code{TRUE}, parallel
execution using BiocParallel (see next argument \code{BPPARAM}). A note on running
in parallel using BiocParallel: it may be advantageous to remove large, unneeded objects
from the current R environment before calling the function, as it is possible that R's
internal garbage collection will copy these files while running on worker nodes.}

\item{BPPARAM}{Optional parameter object passed internally to \code{bplapply} when
\code{parallel=TRUE}. If not specified, the parameters last registered with \code{register}
will be used.}

\item{seed}{If desired, an integer defining the seed of the random number generator. If
\code{NULL}, a random seed is used.}
}
\value{
An S4 object of class \code{coseqResults}, where conditional
probabilities of cluster membership for each gene in each model is stored as a SimpleList of assay
data, and the corresponding {log likelihood, ICL value, number of
clusters, and form of Gaussian model} for each model are stored as metadata.
}
\description{
This is the primary user interface for the \code{coseq} package.
Generic S4 methods are implemented to perform co-expression or co-abudance analysis of
high-throughput sequencing data, with or without data transformation, using K-means or mixture models.
The supported classes are \code{matrix}, \code{data.frame}, and \code{DESeqDataSet}.
The output of \code{coseq} is an S4 object of class \code{coseqResults}.
}
\examples{
## Simulate toy data, n = 300 observations
set.seed(12345)
countmat <- matrix(runif(300*4, min=0, max=500), nrow=300, ncol=4)
countmat <- countmat[which(rowSums(countmat) > 0),]
conds <- rep(c("A","B","C","D"), each=2)

## Run the Normal mixture model for K = 2,3,4
run_arcsin <- coseq(object=countmat, K=2:4, iter=5, transformation="arcsin",
                    model="Normal", seed=12345)
run_arcsin

## Plot and summarize results
plot(run_arcsin)
summary(run_arcsin)

## Compare ARI values for all models (no plot generated here)
ARI <- compareARI(run_arcsin, plot=FALSE)

## Compare ICL values for models with arcsin and logit transformations
run_logit <- coseq(object=countmat, K=2:4, iter=5, transformation="logit",
                   model="Normal")
compareICL(list(run_arcsin, run_logit))

## Use accessor functions to explore results
clusters(run_arcsin)
likelihood(run_arcsin)
nbCluster(run_arcsin)
ICL(run_arcsin)

## Examine transformed counts and profiles used for graphing
tcounts(run_arcsin)
profiles(run_arcsin)

## Run the K-means algorithm for logclr profiles for K = 2,..., 20
run_kmeans <- coseq(object=countmat, K=2:20, transformation="logclr",
                    model="kmeans")
run_kmeans
}
\author{
Andrea Rau
}
\keyword{methods}
