% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-AllGenerics.R, R/methods.R
\name{compareARI}
\alias{compareARI}
\alias{compareARI-methods}
\alias{compareARI,coseqResults-method}
\alias{compareARI,RangedSummarizedExperiment-method}
\alias{compareARI,matrix-method}
\alias{compareARI,data.frame-method}
\title{Pairwise comparisons of ARI values among a set of clustering partitions}
\usage{
compareARI(object, ...)

\S4method{compareARI}{coseqResults}(
  object,
  K = NULL,
  parallel = FALSE,
  BPPARAM = bpparam(),
  plot = TRUE,
  ...
)

\S4method{compareARI}{matrix}(object, parallel = FALSE, BPPARAM = bpparam(), plot = TRUE, ...)

\S4method{compareARI}{data.frame}(object, parallel = FALSE, BPPARAM = bpparam(), plot = TRUE, ...)
}
\arguments{
\item{object}{Object of class \code{coseqResults} or \code{RangedSummarizedExperiment},
or alternatively a \emph{n} x \emph{M} \code{data.frame} or \code{matrix}
containing the clustering partitions for \emph{M} different models}

\item{...}{Additional optional parameters for corrplot}

\item{K}{If \code{NULL}, pairwise ARI values will be calculated among every model in
object \code{x}. Otherwise, \code{K} provides a vector of cluster numbers identifying
a subset of models in \code{x}.}

\item{parallel}{If \code{FALSE}, no parallelization. If \code{TRUE}, parallel
execution using BiocParallel (see next argument \code{BPPARAM}).
Note that parallelization is unlikely to be helpful unless the number of
observations \emph{n} in the clustering partitions or the number of
models \emph{M} are very large.}

\item{BPPARAM}{Optional parameter object passed internally to \code{bplapply}
when \code{parallel=TRUE}. If not specified, the parameters last registered
with \code{register} will be used.}

\item{plot}{If \code{TRUE}, provide a heatmap using corrplot to visualize
the calculated pairwise ARI values.}
}
\value{
Matrix of adjusted rand index values calculated between each pair
of models.
}
\description{
Provides the adjusted rand index (ARI) between pairs of clustering paritions.
}
\examples{
## Simulate toy data, n = 300 observations
set.seed(12345)
countmat <- matrix(runif(300*4, min=0, max=500), nrow=300, ncol=4)
countmat <- countmat[which(rowSums(countmat) > 0),]
conds <- rep(c("A","B","C","D"), each=2)

## Run the Normal mixture model for K = 2,3,4
run_arcsin <- coseq(object=countmat, K=2:4, iter=5, transformation="arcsin",
                    model="Normal", seed=12345)
run_arcsin

## Plot and summarize results
plot(run_arcsin)
summary(run_arcsin)

## Compare ARI values for all models (no plot generated here)
ARI <- compareARI(run_arcsin, plot=FALSE)

## Compare ICL values for models with arcsin and logit transformations
run_logit <- coseq(object=countmat, K=2:4, iter=5, transformation="logit",
                   model="Normal")
compareICL(list(run_arcsin, run_logit))

## Use accessor functions to explore results
clusters(run_arcsin)
likelihood(run_arcsin)
nbCluster(run_arcsin)
ICL(run_arcsin)

## Examine transformed counts and profiles used for graphing
tcounts(run_arcsin)
profiles(run_arcsin)

## Run the K-means algorithm for logclr profiles for K = 2,..., 20
run_kmeans <- coseq(object=countmat, K=2:20, transformation="logclr",
                    model="kmeans")
run_kmeans
}
\author{
Andrea Rau
}
