% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormMixClus-functions.R
\name{NormMixClusK}
\alias{NormMixClusK}
\title{Normal mixture model estimation}
\usage{
NormMixClusK(
  y_profiles,
  K,
  alg.type = "EM",
  init.runs = 50,
  init.type = "small-em",
  GaussianModel = "Gaussian_pk_Lk_Ck",
  init.iter = 20,
  iter = 1000,
  cutoff = 0.001,
  verbose = TRUE,
  digits = 3,
  seed = NULL
)
}
\arguments{
\item{y_profiles}{y (\emph{n} x \emph{q}) matrix of observed profiles for \emph{n}
observations and \emph{q} variables}

\item{K}{Number of clusters (a single value).}

\item{alg.type}{Algorithm to be used for parameter estimation:
\dQuote{\code{EM}}, \dQuote{\code{CEM}}, \dQuote{\code{SEM}}}

\item{init.runs}{Number of runs to be used for the Small-EM strategy, with a default value of 50}

\item{init.type}{Type of initialization strategy to be used:
\dQuote{\code{small-em}} for the Small-EM strategy, \dQuote{\code{random}}, \dQuote{\code{CEM}},
or \dQuote{\code{SEMMax}}}

\item{GaussianModel}{One of the 28 forms of Gaussian models defined in Rmixmod,
by default equal to the \code{"Gaussian_pk_Lk_Ck"} (i.e., a general family model with free
proportions, free volume, free shape, and free orientation)}

\item{init.iter}{Number of iterations to be used within each run for the
Small-EM strategry, with a default value of 20}

\item{iter}{Maximum number of iterations to be run for the chosen algorithm}

\item{cutoff}{Cutoff to declare algorithm convergence}

\item{verbose}{If \code{TRUE}, verbose output is created}

\item{digits}{Integer indicating the number of decimal places to be used for the
\code{probaPost} output}

\item{seed}{If desired, an integer defining the seed of the random number generator. If
\code{NULL}, a random seed is used.}
}
\value{
An S4 object of class \code{RangedSummarizedExperiment}, with conditional
probabilities of cluster membership for each gene stored as assay data, and
{log likelihood, ICL value, number of
clusters, and form of Gaussian model} stored as metadata.
}
\description{
Perform co-expression and co-abudance analysis of high-throughput
sequencing data, with or without data transformation, using a Normal
mixture models for single number of clusters \emph{K}.
The output of \code{NormMixClusK} is an S4 object of
class \code{RangedSummarizedExperiment}.
}
\examples{
## Simulate toy data, n = 300 observations
set.seed(12345)
countmat <- matrix(runif(300*4, min=0, max=500), nrow=300, ncol=4)
countmat <- countmat[which(rowSums(countmat) > 0),]
profiles <- transformRNAseq(countmat, norm="none",
                            transformation="arcsin")$tcounts

conds <- rep(c("A","B","C","D"), each=2)

## Run the Normal mixture model for K = 2,3
## Object of class coseqResults
run <- NormMixClus(y=profiles, K=2:3, iter=5)
run

## Run the Normal mixture model for K=2
## Object of class SummarizedExperiment0
run2 <- NormMixClusK(y=profiles, K=2, iter=5)

## Summary of results
summary(run)

## Re-estimate mixture parameters for the model with K=2 clusters
param <- NormMixParam(run, y_profiles=profiles)

}
\author{
Cathy Maugis-Rabusseau, Andrea Rau
}
