% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\docType{methods}
\name{CNV.segment}
\alias{CNV.segment}
\alias{CNV.segment,CNV.analysis-method}
\title{CNV.segment}
\usage{
CNV.segment(object, ...)

\S4method{CNV.segment}{CNV.analysis}(object, alpha = 0.001, nperm = 50000,
  min.width = 5, undo.splits = "sdundo", undo.SD = 2.2, verbose = 0,
  ...)
}
\arguments{
\item{object}{\code{CNV.analysis} object.}

\item{...}{Additional parameters supplied to the \code{segment} method of the \code{DNAcopy} package.}

\item{alpha}{See details. Defaults to 0.001.}

\item{nperm}{See details. Defaults to 50000.}

\item{min.width}{See details. Defaults to 5.}

\item{undo.splits}{See details. Defaults to 'sdundo'.}

\item{undo.SD}{See details. Defaults to 2.2.}

\item{verbose}{See details. Defaults to 0.}
}
\value{
\code{CNV.analysis} object.
}
\description{
Segment bin values (wrapper of \code{DNAcopy} package).
}
\details{
This method is a wrapper of the CNA, segment, segments.summary and segments.p methods of the DNAcopy package. Please refer to the respective man pages for more detailed information. The default parameters of \code{CNV.segment} override some of the default parameters of segment and are optimized for 450k data CNV analysis.
}
\examples{
# prepare
library(minfiData)
data(MsetEx)
d <- CNV.load(MsetEx)
data(detail_regions)
anno <- CNV.create_anno(detail_regions = detail_regions)

# create object
x <- CNV.fit(query = d['GroupB_1'], ref = d[c('GroupA_1', 'GroupA_2', 'GroupA_3')], anno)

# modify object
x <- CNV.bin(x)
x <- CNV.detail(x)
x <- CNV.segment(x)

# general information
x
show(x)

# coefficients of linear regression
coef(x)

# show or replace sample name
names(x)
names(x) <- 'Sample 1'
}
\author{
Volker Hovestadt \email{conumee@hovestadt.bio}
}
