% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.konecny.subtypes.R
\name{get.konecny.subtypes}
\alias{get.konecny.subtypes}
\title{Get ovarian cancer subtypes as defined by Konecny et al., 2014}
\usage{
get.konecny.subtypes(expression.matrix, entrez.ids)
}
\arguments{
\item{expression.matrix}{A matrix of gene expression values with rows as
genes, columns as samples.}

\item{entrez.ids}{A vector of Entrez Gene IDs, corresponding to the rows of
\code{expression.matrix}}
}
\value{
A list with first value \code{Konecny.subtypes} containing a factor
of subtype names; and second value \code{spearman.cc.vals} containing the
Spearman correlation values per subtype
}
\description{
Get ovarian cancer subtypes as defined by Konecny et al., 2014
}
\examples{
library(Biobase)
data(GSE14764.eset)
expression.matrix <- exprs(GSE14764.eset)
entrez.ids <- as.character(fData(GSE14764.eset)$EntrezGene.ID)
get.konecny.subtypes(expression.matrix, entrez.ids)
}
\references{
Konecny et al. \emph{Prognostic and therapeutic relevance of
molecular subtypes in high-grade serous ovarian cancer.}
Journal of the National Cancer Institute (2014).
}
