% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.bentink.subtypes.R
\name{get.bentink.subtypes}
\alias{get.bentink.subtypes}
\title{Get ovarian cancer subtypes as defined by Bentink et al., 2012}
\usage{
get.bentink.subtypes(expression.matrix, entrez.ids)
}
\arguments{
\item{expression.matrix}{A matrix of gene expression values with rows as
genes, columns as samples.}

\item{entrez.ids}{A vector of Entrez Gene IDs, corresponding to the rows of
\code{expression.matrix}}
}
\value{
A list with first value \code{Bentink.subtypes} containing a factor
of subtype names; and second value \code{angio} containing the ouput of
\code{genefu::ovcAngiogenic}
}
\description{
Get ovarian cancer subtypes as defined by Bentink et al., 2012
}
\examples{
library(Biobase)
library(genefu)
data(GSE14764.eset)
expression.matrix <- exprs(GSE14764.eset)
entrez.ids <- as.character(fData(GSE14764.eset)$EntrezGene.ID)
get.bentink.subtypes(expression.matrix, entrez.ids)
}
\references{
Bentink et al. \emph{Angiogenic mRNA and microRNA gene expression
 signature predicts
a novel subtype of serous ovarian cancer.} PloS one (2012).
}
