% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varianceExplained.R
\name{plotICVarianceExplained}
\alias{plotICVarianceExplained}
\title{Barplot variance explained by each IC}
\usage{
plotICVarianceExplained(
  cica,
  sort = NULL,
  las = 2,
  title = "Variance explained per IC",
  x.cex = NULL,
  ...
)
}
\arguments{
\item{cica}{consICA compliant list}

\item{sort}{specify the arrangement as 'asc'/'desc'. No sorting if NULL}

\item{las}{orientation value for the axis labels (0 - always parallel to the 
axis, 1 - always horizontal, 2 - always perpendicular to the axis, 
3 - always vertical)}

\item{title}{character string with title of the plot}

\item{x.cex}{specify the size of the tick label numbers/text with a numeric 
value of length 1}

\item{...}{extra arguments to be passed to \code{\link{barplot}}}
}
\value{
A numeric vector compliant to `barplot` output
}
\description{
Method to plot variance explained (R-squared) by the MOFA model 
for each view and latent factor. \cr
As a measure of variance explained for gaussian data we adopt the 
coefficient of determination (R2). \cr
For details on the computation see the help of the 
\code{\link[consICA]{estimateVarianceExplained}} function
}
\examples{
data("samples_data")
# cica <- consICA(samples_data, ncomp=15, ntry=10, show.every=0)
# p <- plotICVarianceExplained(cica, sort = "asc")
}
