% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/utils.R
\name{weights_from_pst}
\alias{weights_from_pst}
\alias{weights_from_pst,matrix-method}
\alias{weights_from_pst,data.frame-method}
\title{weights_from_pst}
\usage{
weights_from_pst(pseudotime, ...)

\S4method{weights_from_pst}{matrix}(pseudotime)

\S4method{weights_from_pst}{data.frame}(pseudotime)
}
\arguments{
\item{pseudotime}{A matrix or data.frame of \[ncells\] by \[nCurves\].}

\item{...}{Other parameters including:}
}
\value{
A object of the same type and dimensions as the original object, with the
weights for each curve and cell.
}
\description{
Most trajectory inference methods do not perform soft assignment
but instead assign cells to all possible lineages before a branching point,
and then to one or another. This function re-creates a weight matrix from those
matrices of pseudotime
}
\examples{
data(list = 'slingshotExample', package = "slingshot")
if (!"cl" \%in\% ls()) {
  rd <- slingshotExample$rd
  cl <- slingshotExample$cl
}
sds <- slingshot::slingshot(rd, cl)
weights_from_pst(slingshot::slingPseudotime(sds))
}
