% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genome_assembly.R
\name{compare_genome_stats}
\alias{compare_genome_stats}
\title{Compare user-defined assembly statistics with statistics of NCBI genomes}
\usage{
compare_genome_stats(ncbi_stats = NULL, user_stats = NULL)
}
\arguments{
\item{ncbi_stats}{A data frame of summary statistics for a particular
taxon obtained from the NCBI, as obtained with the
function \code{get_genome_stats}.}

\item{user_stats}{A data frame with assembly statistics obtained by
the user. A column named \strong{accession} is mandatory, and it must contain
unique identifiers for the genome(s) analyzed by the user. Dummy variables
can be used as identifiers (e.g., "my_genome_001"), as long as they are
unique. All other column containing assembly stats must have the same names
as their corresponding columns in the data frame specified
in \strong{ncbi_stats}. For instance, stats on total number of genes and
sequence length must be in columns named "gene_count_total" and
"sequence_length", as in the \strong{ncbi_stats} data frame.}
}
\value{
A data frame with the following variables:
\describe{
\item{accession}{character, unique identifier as in user_stats$accession.}
\item{variable}{character, name of the genome assembly metric (e.g., "CC_ratio").}
\item{percentile}{numeric, percentile in the distribution.}
\item{rank}{numeric, rank in the distribution (highest to lowest). For the variable "CC_ratio", ranks go from lowest to highest.}
}
}
\description{
This function helps users analyze their genome assembly stats in a context
by comparing metrics obtained by users with "reference" metrics in
closely-related organisms.
}
\details{
For each genome assembly statistic (e.g., "gene_count_total"), values
in \strong{user_stats} are compared to a distribution of values
from \strong{ncbi_stats}, and their percentile and rank in the distributions
are reported.
}
\examples{
# Use case: user assembled a maize (Zea mays) genome

## Obtain stats for maize genomes on the NCBI
ncbi_stats <- get_genome_stats(taxon = "Zea mays")

## Create a data frame of stats for fictional maize genome
user_stats <- data.frame(
    accession = "my_lovely_maize",
    sequence_length = 2.4 * 1e9,
    gene_count_total = 50000,
    CC_ratio = 1
)

# Compare stats
compare_genome_stats(ncbi_stats, user_stats)

}
