% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapCmap.R
\docType{methods}
\name{heatmapCmap}
\alias{heatmapCmap}
\alias{heatmapCmap,cogena-method}
\alias{heatmapCmap,cogena}
\title{heatmap designed for for CMap gene set only}
\usage{
heatmapCmap(
  object,
  method = clusterMethods(object),
  nCluster = nClusters(object),
  orderMethod = "max",
  MultiInstance = "drug",
  CutoffNumGeneset = 20,
  CutoffPVal = 0.05,
  mergeMethod = "mean",
  low = "grey",
  high = "red",
  na.value = "white",
  maintitle = NULL,
  printGS = FALSE,
  add2 = TRUE,
  geom = "tile"
)

\S4method{heatmapCmap}{cogena}(
  object,
  method = clusterMethods(object),
  nCluster = nClusters(object),
  orderMethod = "max",
  MultiInstance = "drug",
  CutoffNumGeneset = 20,
  CutoffPVal = 0.05,
  mergeMethod = "mean",
  low = "grey",
  high = "red",
  na.value = "white",
  maintitle = "cogena",
  printGS = FALSE,
  add2 = TRUE,
  geom = "tile"
)
}
\arguments{
\item{object}{a genecl or cogena object}

\item{method}{as clMethods in genecl function}

\item{nCluster}{as nClust in cogena function.}

\item{orderMethod}{the order method, default is max, other options are 
"mean", "all", "I", "II" or a number meaning the ith cluster.}

\item{MultiInstance}{merge multi instances. Options are "drug", "celldrug", "conccelldrug", "concdrug".}

\item{CutoffNumGeneset}{the cut-off of the number of gene sets in the 
return table. The default is 20.}

\item{CutoffPVal}{the cut-off of p-value. The default is 0.05.}

\item{mergeMethod}{max or mean. The default is mean.}

\item{low}{colour for low end of gradient.}

\item{high}{colour for high end of gradient.}

\item{na.value}{Colour to use for missing values.}

\item{maintitle}{a character. Default is null}

\item{printGS}{print the enriched gene set names or not. Default is FALSE}

\item{add2}{enrichment score for add Up and Down reuglated genes.}

\item{geom}{tile or circle}
}
\value{
a gene set enrichment heatmap
}
\description{
heatmapCmap is desgined for the cogena result from CMap
only so as to collapse the multi-isntance drugs in CMap!
}
\details{
orderMethod:
\itemize{
\item max. ordered by the max value in clusters beside all
\item mean. ordered by the mean value in clusters beside all
\item All. ordered by all genes
\item Up. ordered by up-regulated genes (add2 should be TRUE)
\item Down. ordered by down-regulated genes (add2 should be TRUE)
}

MultiInstance:
\itemize{
\item drug. merge based on cmap_name
\item celldrug. merge based on cmap_name and cell type
\item conccelldrug. merge based on cmap_name, cell type and concentration
}
}
\examples{
data(Psoriasis)
annofile <- system.file("extdata", "CmapDn100.gmt.xz", package="cogena")
\dontrun{
genecl_result <- coExp(DEexprs, nClust=3, clMethods=c("pam"), 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)
clen_res1 <- clEnrich(genecl_result, annofile=annofile, sampleLabel=sampleLabel)

heatmapCmap(clen_res1, "pam", "3", orderMethod="2")
heatmapCmap(clen_res1, "pam", "3", orderMethod="2", MultiInstance="concdrug")
}
}
