% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corInCluster.R
\name{corInCluster}
\alias{corInCluster}
\alias{corInCluster,cogena-method}
\alias{corInCluster,cogena_methods}
\title{Correlation in the cluster of a cogena object}
\usage{
corInCluster(
  object,
  method,
  nCluster,
  ith,
  corMethod = "pearson",
  plotMethod = "circle",
  type = "upper",
  ...
)

\S4method{corInCluster}{cogena}(
  object,
  method = clusterMethods(object),
  nCluster = nClusters(object),
  ith,
  corMethod = "pearson",
  plotMethod = "circle",
  type = "upper",
  ...
)
}
\arguments{
\item{object}{a cogena object}

\item{method}{a clustering method}

\item{nCluster}{cluster number}

\item{ith}{the i-th cluster (should no more than nCluster)}

\item{corMethod}{a character string indicating which correlation coefficient 
(or covariance) is to be computed. One of "pearson" (default), "kendall", or 
"spearman", can be abbreviated.}

\item{plotMethod}{the visualization method of correlation matrix 
to be used. Currently, it supports seven methods, named "circle" (default), 
"square", "ellipse", "number", "pie", "shade" and "color". See examples in 
\code{\link[corrplot]{corrplot}} for details}

\item{type}{"full" (default), "upper" or "lower", display full 
matrix, lower triangular or upper triangular matrix. See examples in 
\code{\link[corrplot]{corrplot}} for details}

\item{...}{other parameters to \code{\link[corrplot]{corrplot}} function.}
}
\value{
a correlation figure.
}
\description{
Correlation in the cluster of a cogena object. This is helpful if the number 
of genes in cluster are small.
}
\examples{
data(Psoriasis)
annofile <- system.file("extdata", "c2.cp.kegg.v7.01.symbols.gmt.xz", 
package="cogena")

\dontrun{
genecl_result <- coExp(DEexprs, nClust=2:3, clMethods=c("hierarchical","kmeans"), 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)

clen_res <- clEnrich(genecl_result, annofile=annofile, sampleLabel=sampleLabel)

corInCluster(clen_res, "kmeans", "3", "3")
corInCluster(clen_res, "kmeans", "3", "3", plotMethod="square")
}

}
\seealso{
\code{\link{clEnrich}} \code{\link[corrplot]{corrplot}}
}
