% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEI.R
\name{PEI}
\alias{PEI}
\title{Significance of Gene sets enrichment.}
\usage{
PEI(genenames, annotation, annotationGenesPop)
}
\arguments{
\item{genenames}{a vector of gene names.}

\item{annotation}{data.frame with the gene (like all the differentially 
expressed genes) in row, gene set in column.}

\item{annotationGenesPop}{data.frame with the gene in row, gene set 
in column. Here genes are genes in population with filering the 
non-nformative genes better.}
}
\value{
a vector with P-values.
}
\description{
Caculating the significance of Gene sets enrichment based on the 
hypergeometric test. This function is mainly used internally.
}
\details{
Here the genes in annotation can be a varity of types. like all the DEG, 
up-regualted genes or genes in a cluster. the gene names should be 
consistent with the genes in the gene sets.
}
\examples{
data(Psoriasis)
data(AllGeneSymbols)
annofile <- system.file("extdata", "c2.cp.kegg.v7.01.symbols.gmt.xz", package="cogena")
annoBG <- gene2set(annofile, AllGeneSymbols)
res <- PEI(rownames(DEexprs)[1:200], gene2set(annofile, rownames(DEexprs)[1:200]), annoBG)

}
