% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonTable-class.R
\docType{methods}
\name{[,codonTable-method}
\alias{[,codonTable-method}
\alias{[[,codonTable-method}
\alias{subset.codonTable}
\title{Subset \code{codonTable} object.}
\usage{
\S4method{[}{codonTable}(x, i)

\S4method{[[}{codonTable}(x, i)

\method{subset}{codonTable}(x, subset, ...)
}
\arguments{
\item{x}{A \code{codonTable} object to be subset.}

\item{i}{
    indices specifying elements to extract or replace.  Indices are
    \code{numeric} or \code{character} vectors or empty (missing) or
    \code{NULL}.  Numeric values are coerced to integer as by
    \code{\link{as.integer}} (and hence truncated towards zero).
    Character vectors will be matched to the \code{\link{names}} of the
    object (or for matrices/arrays, the \code{\link{dimnames}}):
    see \sQuote{Character indices} below for further details.

    For \code{[}-indexing only: \code{i}, \code{j}, \code{\dots} can be
    logical vectors, indicating elements/slices to select.  Such vectors
    are recycled if necessary to match the corresponding extent.
    \code{i}, \code{j}, \code{\dots} can also be negative integers,
    indicating elements/slices to leave out of the selection.

    When indexing arrays by \code{[} a single argument \code{i} can be a
    matrix with as many columns as there are dimensions of \code{x}; the
    result is then a vector with elements corresponding to the sets of
    indices in each row of \code{i}.

    An index value of \code{NULL} is treated as if it were \code{integer(0)}.
  }

\item{subset}{A logical or character vector indicating which elements of
\code{x} to keep. If logical, \code{subset} should be of length
\code{length(x)}. If character, \code{subset} should contain
 at least some of the elements of either \code{getKO(x)} or
 \code{getCOG(x)}.}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
subsets of \code{codonTable} object, keeping in each slot
only those elements that meet the criteria in \code{subset}, if specified.
}
\description{
Subset \code{codonTable} object.
}
\examples{
# create codonTable
mat <- matrix(sample(1:10, 610, replace = TRUE), nrow = 10)
cT <- codonTable(mat) # produces informative warning
cT
cT[1]
cT[[1]]
subset(cT, c(rep(c(TRUE,FALSE), 5))) # subset odd sequences

cT <- setKO(cT, rep(c("K00001", "K00002"), 5))
subset(cT, "K00001")

cT <- setCOG(cT, rep(c("COG0001", "COG0002"), 5))
subset(cT, "COG0001")

}
