% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\docType{methods}
\name{enrichMatrix}
\alias{enrichMatrix}
\alias{enrichMatrix,list-method}
\title{Extract chosen enrichment values to a matrix.}
\usage{
enrichMatrix(x, variable, replace.na = TRUE)

\S4method{enrichMatrix}{list}(x, variable, replace.na = TRUE)
}
\arguments{
\item{x}{A named list of \code{AnnotatedDataFrame} objects.}

\item{variable}{Character, indicating the statistic values to extract from
\code{AnnotatedDataFrame} objects in x, must be one of
\code{c("enrich","M","A")}.}

\item{replace.na}{logical, whether to replace NA values in the output.
If `TRUE` (default), NAs will be replaced by 0. Alternatively,
if numueric, NAs will be replaced by that given value.}
}
\value{
\code{matrix} with sequences' annotations as rows, and variable
  values for different samples as columns.
}
\description{
Extract enrichment values from multiple samples, i.e.
\code{AnnotatedDataFrame} objects. Note that the samples should contain
annotations of the same type (i.e. the same ontology). The data in matrix
format can be easily used in different types of downstream analyses,
such as GAGE, and visualised, e.g. using a heatmap.
}
\examples{
require(Biobase)

# create contingency table
s <- getKO(LD94)
v <- as.numeric(MELP(LD94, ribosomal = TRUE))
ct <- crossTab(s, v, percentiles = 0.2)

# enrichment analysis
enr <- enrichment(ct)
enr # for help, see `?Biobase::AnnotatedDataFrame`
head(pData(enr$top_0.2), 10)
head(pData(enr$gt_1), 10)
enrm <- enrichMatrix(enr, "M")
head(enrm)

}
