% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetResiduals.R
\name{GetResiduals}
\alias{GetResiduals}
\title{Get Linear Model Residuals}
\usage{
GetResiduals(
  dnam,
  betaToM = TRUE,
  epsilon = 1e-08,
  pheno_df,
  covariates_char,
  nCores_int = 1L,
  ...
)
}
\arguments{
\item{dnam}{data frame or matrix of methylation values with row names = CpG
IDs and column names = sample IDs. This is often the genome-wide array
data.}

\item{betaToM}{indicates if methylation beta values (ranging from [0, 1])
should be converted to M values (ranging from (-Inf, Inf)). Note that if
beta values are the input to \code{dnam}, then \code{betaToM} should be set
to \code{TRUE}, otherwise \code{FALSE}.}

\item{epsilon}{When transforming beta values to M values, what should be done
to values exactly equal to 0 or 1? The M value transformation would yield
\code{-Inf} or \code{Inf} which causes issues in the statistical model. We
 thus replace all values exactly equal to 0 with 0 + \code{epsilon}, and
 we replace all values exactly equal to 1 with 1 - \code{epsilon}. Defaults
 to \code{epsilon = 1e-08}.}

\item{pheno_df}{a data frame with phenotype and covariates, with variable
\code{Sample} indicating sample IDs.}

\item{covariates_char}{character vector for names of the covariate variables}

\item{nCores_int}{Number of computing cores to be used when executing code
in parallel. Defaults to 1 (serial computing).}

\item{...}{Dots for additional arguments passed to the cluster constructor.
See \code{\link{CreateParallelWorkers}} for more information.}
}
\value{
output a matrix of residual values in the same dimension as
  \code{dnam}
}
\description{
Remove covariate effects from methylayion values by fitting
  probe-specific linear models
}
\details{
This function fits an ordinary linear model predicting methylation
  values for each probe from the specified covariates. This process will be
  useful in scenarios where methylation values in a region or at an
  individual probe are known \emph{a priori} to have differential methylation
  independent of the disease or condition of interest.
}
\examples{
   data(betasChr22_df)

   data(pheno_df)

   GetResiduals(
     dnam = betasChr22_df[1:10, 1:10],
     betaToM = TRUE,
     pheno_df = pheno_df,
     covariates_char = c("age.brain", "sex", "slide")
   )

}
