% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCT.R
\name{GCT}
\alias{GCT}
\title{Initialize an object of class \code{GCT}}
\usage{
GCT(
  mat = NULL,
  rdesc = NULL,
  cdesc = NULL,
  src = NULL,
  rid = NULL,
  cid = NULL,
  matrix_only = FALSE
)
}
\arguments{
\item{mat}{a matrix}

\item{rdesc}{a \code{data.frame} of row metadata}

\item{cdesc}{a \code{data.frame} of column metadata}

\item{src}{path to a GCT file to read}

\item{rid}{vector of character identifiers for rows}

\item{cid}{vector of character identifiers for columns}

\item{matrix_only}{logical indicating whether to read just the matrix
data from \code{src}}
}
\value{
a \code{GCT} object
}
\description{
Initialize an object of class \code{GCT}
}
\details{
If \code{mat} is provided, \code{rid} and \code{cid} are treated as
  the row and column identifiers for the matrix and are assigned to the
  \code{rid} and \code{cid} slots of the \code{GCT} object.
  
  If \code{mat} is not provided but \code{src} is provided,
  \code{rid} and \code{cid} are treated as filters. Data will be read from
  the file path provided to \code{src} and will then be restricted to the
  character ids or integer indices provided to \code{rid} and \code{cid}.
  In a similar manner, \code{matrix_only} controls whether the
  row and column metadata are also read from the \code{src} file path.
}
\examples{
# an empty object
(g <- GCT())
# with a matrix
# note we must specify row and column ids
(g <- GCT(mat=matrix(rnorm(100), nrow=10),
          rid=letters[1:10], cid=letters[1:10]))
# from file
gct_file <- system.file("extdata", "modzs_n25x50.gctx", package="cmapR")
(g <- GCT(src=gct_file))
}
\seealso{
Other GCTX parsing functions: 
\code{\link{append.dim}()},
\code{\link{fix.datatypes}()},
\code{\link{parse.gctx}()},
\code{\link{process_ids}()},
\code{\link{read.gctx.ids}()},
\code{\link{read.gctx.meta}()},
\code{\link{write.gctx.meta}()},
\code{\link{write.gctx}()},
\code{\link{write.gct}()}
}
\concept{GCTX parsing functions}
