% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_rank_bias}
\alias{plot_rank_bias}
\title{Query rank bias results}
\usage{
plot_rank_bias(bias_df, organism = "hsapiens")
}
\arguments{
\item{bias_df}{data.frame of rank diff matrix between cluster and reference cell types}

\item{organism}{for GO term analysis, organism name: human - 'hsapiens', mouse - 'mmusculus'}
}
\value{
ggplot object of distribution and annotated GO terms
}
\description{
Query rank bias results
}
\examples{
\dontrun{
avg <- average_clusters(
    mat = pbmc_matrix_small,
    metadata = pbmc_meta,
    cluster_col = "classified",
    if_log = FALSE
)

rankdiff <- find_rank_bias(
    avg,
    cbmc_ref,
    query_genes = pbmc_vargenes
)

qres <- query_rank_bias(
    rankdiff,
    "CD14+ Mono",
    "CD14+ Mono"
)

g <- plot_rank_bias(
    qres
)
}
}
