% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_cor_heatmap}
\alias{plot_cor_heatmap}
\title{Plot similarity measures on heatmap}
\usage{
plot_cor_heatmap(
  cor_mat,
  metadata = NULL,
  cluster_col = NULL,
  col = not_pretty_palette,
  legend_title = NULL,
  ...
)
}
\arguments{
\item{cor_mat}{input similarity matrix}

\item{metadata}{input metadata with per cell tsne
or umap cooordinates and cluster ids}

\item{cluster_col}{colname of clustering data in metadata,
defaults to rownames of the metadata if not supplied.}

\item{col}{color ramp to use}

\item{legend_title}{legend title to pass to Heatmap}

\item{...}{passed to Heatmap}
}
\value{
complexheatmap object
}
\description{
Plot similarity measures on heatmap
}
\examples{
res <- clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    query_genes = pbmc_vargenes,
    cluster_col = "classified",
    per_cell = FALSE
)

plot_cor_heatmap(res)
}
