% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_cor}
\alias{plot_cor}
\title{Plot similarity measures on a tSNE or umap}
\usage{
plot_cor(
  cor_mat,
  metadata,
  data_to_plot = colnames(cor_mat),
  cluster_col = NULL,
  x = "UMAP_1",
  y = "UMAP_2",
  scale_legends = FALSE,
  ...
)
}
\arguments{
\item{cor_mat}{input similarity matrix}

\item{metadata}{input metadata with per cell tsne or
umap coordinates and cluster ids}

\item{data_to_plot}{colname of data to plot, defaults to all}

\item{cluster_col}{colname of clustering data in metadata, defaults
to rownames of the metadata if not supplied.}

\item{x}{metadata column name with 1st axis dimension.
defaults to "UMAP_1".}

\item{y}{metadata column name with 2nd axis dimension.
defaults to "UMAP_2".}

\item{scale_legends}{if TRUE scale all legends to maximum values in entire
correlation matrix. if FALSE scale legends to maximum for each plot. A
two-element numeric vector can also be passed to supply
custom values i.e. c(0, 1)}

\item{...}{passed to plot_dims}
}
\value{
list of ggplot objects, cells projected by dr,
colored by cor values
}
\description{
Plot similarity measures on a tSNE or umap
}
\examples{
res <- clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    query_genes = pbmc_vargenes,
    cluster_col = "classified"
)

plot_cor(
    cor_mat = res,
    metadata = pbmc_meta,
    data_to_plot = colnames(res)[1:2],
    cluster_col = "classified",
    x = "UMAP_1",
    y = "UMAP_2"
)
}
