% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{assess_rank_bias}
\alias{assess_rank_bias}
\title{Find rank bias}
\usage{
assess_rank_bias(
  avg_mat,
  ref_mat,
  query_genes = NULL,
  res,
  organism,
  plot_name = NULL,
  rds_name = NULL,
  expand_unassigned = FALSE
)
}
\arguments{
\item{avg_mat}{average expression matrix}

\item{ref_mat}{reference expression matrix}

\item{query_genes}{original vector of genes used to clustify}

\item{res}{dataframe of idents, such as output of cor_to_call}

\item{organism}{for GO term analysis, organism name: human - 'hsapiens', mouse - 'mmusculus'}

\item{plot_name}{name for saved pdf, if NULL then no file is written (default)}

\item{rds_name}{name for saved rds of rank_diff, if NULL then no file is written (default)}

\item{expand_unassigned}{test all ref clusters for unassigned results}
}
\value{
pdf of ggplot object
}
\description{
Find rank bias
}
\examples{
\dontrun{
avg <- average_clusters(
    pbmc_matrix_small,
    pbmc_meta$seurat_clusters
)
res <- clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    query_genes = pbmc_vargenes,
    cluster_col = "seurat_clusters"
)
top_call <- cor_to_call(
    res,
    metadata = pbmc_meta,
    cluster_col = "seurat_clusters",
    collapse_to_cluster = FALSE,
    threshold = 0.8
)
res_rank <- assess_rank_bias(
    avg,
    cbmc_ref,
    res = top_call
)
}
}
