% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windowProfile.R
\name{windowProfile}
\alias{windowProfile}
\title{windowProfile for the GRanges objects}
\usage{
windowProfile(
    object,
    annotation,
    title = "Window Profile",
    group = NA,
    nomap = FALSE
)
}
\arguments{
\item{object}{A GRanges object which contains all the peaks that you
want to check}

\item{annotation}{A GRanges object that includes the customised genomic
region.}

\item{title}{The main title for the output meta gene profile plot.}

\item{group}{The column name which contains the information of grouping
for making the comparison plot. NA means all the peaks belongs to
the same catagory.}

\item{nomap}{A logical vector (TRUE or FALSE). It indicates whether you
would like to exclude peaks that cannot assign to annotations
in the plot.}
}
\value{
A list object, the list 1 contains the information of the
        assignment of the peaks and their position value within the given
        region. The value close to 1 means the peak close to the end of
        region in 3' end direction. The list 2 includes the ggplot of
        windowProfile.
}
\description{
An function to check the position of peaks within the given
    GRanges windows.
}
\details{
\itemize{
    Here is an explanation of output meta data in the \code{list 1}:
    \item \code{center}: The center position of each peaks. This center
    position is used for calculating the position of peaks within the
    genomic regions.
    \item \code{window_S} and \code{window_E}: The boundary of the
    annotation that peaks are assigned.
    \item \code{window_length}: The length of the annotation feature that
    peak assigned.
    \item \code{window_map}: The relative position of each peak. This value
    close to 0 means this peak located close to the 5' end of the
    annotation. The position value close to one means the peak close to
    the 3' end. Value 3 means this peaks can not map to any annotation.
}
}
\examples{
## Load the test data and get the path to the test gff3 file
testpath <- system.file("extdata", package = "cliProfiler")
test <- readRDS(file.path(testpath, "test.rds"))
test_gff3 <- file.path(testpath, "annotation_test.gff3")
test_gff3 <- rtracklayer::import.gff3(test_gff3)

output <- windowProfile(test, test_gff3)
}
\author{
You Zhou, Kathi Zarnack
}
