% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.buildClassifier.R
\name{buildClassifier}
\alias{buildClassifier}
\title{Build a Naive Bayes Classifier}
\usage{
buildClassifier(
  Ndata.NaiveBayes,
  Pdata.NaiveBayes,
  upstream = 40L,
  downstream = 30L,
  wordSize = 6L,
  alphabet = c("ACGT")
)
}
\arguments{
\item{Ndata.NaiveBayes}{A data.frame, containing features for the negative 
training data, described further in \code{\link[cleanUpdTSeq]{data.NaiveBayes}}.}

\item{Pdata.NaiveBayes}{A data.frame, containing features for the positive 
training data, described further in \code{\link[cleanUpdTSeq]{data.NaiveBayes}}.}

\item{upstream}{An integer(1) vector, length of upstream sequence to retrieve.}

\item{downstream}{An integer(1) vector, length of downstream sequence to 
retrieve.}

\item{wordSize}{An integer(1) vector,  size of the kmer feature for the
upstream sequence. wordSize = 6 should always be used.}

\item{alphabet}{A character(1) vector, a string containing DNA bases.
By default, "ACTG".}
}
\value{
An object of class "naiveBayes".
}
\description{
Computes the conditional a-posterior probabilities of a categorical class
variable given independent predictor variables using the Bayes rule.
}
\examples{

if (interactive()){
    data(data.NaiveBayes)
    classifier <- buildClassifier(data.NaiveBayes$Negative, 
                                  data.NaiveBayes$Positive)
}

}
\seealso{
\code{\link[e1071]{naiveBayes}}
}
\author{
Jianhong Ou
}
