% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFilesPredictionTool.R
\name{importCircExplorer2}
\alias{importCircExplorer2}
\title{Import circRNAs detected by CircExplorer2}
\usage{
importCircExplorer2(pathToFile)
}
\arguments{
\item{pathToFile}{A character string specifying the path to the file
containing the detected circRNAs.}
}
\value{
A data frame.
}
\description{
The function importCircExplorer2 is specifically designed to
read and adapt the circExplorer2 v2.3.4 output file (circularRNA_full.txt).
See \url{https://github.com/YangLab/CIRCexplorer2.git} for more details.
}
\examples{
# Path to an example file containing circRNAs detected by CIRCexplorer2
pathToFile <- system.file("extdata", "circexplorer2/circRNAs_001.txt",
package="circRNAprofiler")

# Inner function.
# Import circRNAs.
importCircExplorer2(pathToFile)

}
\keyword{internal}
