% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRandomBSJunctions.R
\name{getRandomBSJunctions}
\alias{getRandomBSJunctions}
\title{Retrieve random back-spliced junctions}
\usage{
getRandomBSJunctions(gtf, n = 100, f = 10, setSeed = NULL)
}
\arguments{
\item{gtf}{A dataframe containing genome annotation information This can be
generated with \code{\link{formatGTF}}.}

\item{n}{Integer specifying the number of randomly selected transcripts
from which random back-spliced junctions are extracted. Default value = 100.}

\item{f}{An integer specifying the fraction of single exon circRNAs that
have to be present in the output data frame. Default value is 10.}

\item{setSeed}{An integer which is used for selecting random back-spliced 
junctions. Default values is set to NULL.}
}
\value{
A data frame.
}
\description{
The function getRandomBSJunctions() retrieves random
back-spliced junctions from the user genome annotation.
}
\examples{
# Load short version of the gencode v19 annotation file
data("gtf")

# Get 10 random back-spliced junctions
randomBSJunctions <- getRandomBSJunctions(gtf, n = 10, f = 10)

}
