% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCicero.R
\name{generate_ccans}
\alias{generate_ccans}
\title{Generate cis-co-accessibility networks (CCANs)}
\usage{
generate_ccans(
  connections_df,
  coaccess_cutoff_override = NULL,
  tolerance_digits = 2
)
}
\arguments{
\item{connections_df}{Data frame of connections with columns: Peak1, Peak2,
coaccess. Generally, the output of \code{\link{run_cicero}} or
\code{\link{assemble_connections}}}

\item{coaccess_cutoff_override}{Numeric, co-accessibility score threshold to
impose. Overrides automatic calculation.}

\item{tolerance_digits}{The number of digits to calculate cutoff to. Default
is 2 (0.01 tolerance)}
}
\value{
Data frame with two columns - Peak and CCAN. CCAN column indicates
  CCAN assignment. Peaks not included in a CCAN are not returned.
}
\description{
Post process cicero co-accessibility scores to extract modules of sites that
are co-accessible.
}
\details{
CCANs are calculated by first specifying a minimum co-accessibility
  score and then using the Louvain community detection algorithm on the
  subgraph induced by excluding edges below this score. For this function,
  either the user can specify the minimum co-accessibility using
  \code{coaccess_cutoff_override}, or the cutoff can be calculated
  automatically by optimizing for CCAN number. The cutoff calculation can be
  slow, so users may wish to use the \code{coaccess_cutoff_override} after
  initially calculating the cutoff to speed future runs.
}
\examples{
\dontrun{
  data("cicero_data")
  set.seed(18)
  data("human.hg19.genome")
  sample_genome <- subset(human.hg19.genome, V1 == "chr18")
  sample_genome$V2[1] <- 100000
  input_cds <- make_atac_cds(cicero_data, binarize = TRUE)
  input_cds <- reduceDimension(input_cds, max_components = 2, num_dim=6,
                               reduction_method = 'tSNE',
                               norm_method = "none")
  tsne_coords <- t(reducedDimA(input_cds))
  row.names(tsne_coords) <- row.names(pData(input_cds))
  cicero_cds <- make_cicero_cds(input_cds, reduced_coordinates = tsne_coords)
  cicero_cons <- run_cicero(cicero_cds, sample_genome, sample_num = 2)
  ccan_assigns <- generate_ccans(cicero_cons)
 }

}
