% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variability_synergy.R
\name{getAnnotationSynergy}
\alias{getAnnotationSynergy}
\alias{getAnnotationSynergy,SummarizedExperiment,SummarizedExperiment-method}
\alias{getAnnotationSynergy,SummarizedExperiment,MatrixOrmatrix-method}
\alias{getAnnotationSynergy,SummarizedExperiment,list-method}
\alias{getAnnotationSynergy,MatrixOrmatrix,SummarizedExperiment-method}
\alias{getAnnotationSynergy,MatrixOrmatrix,MatrixOrmatrix-method}
\alias{getAnnotationSynergy,MatrixOrmatrix,list-method}
\title{getAnnotationSynergy}
\usage{
getAnnotationSynergy(object, annotations, ...)

\S4method{getAnnotationSynergy}{SummarizedExperiment,SummarizedExperiment}(
  object,
  annotations,
  background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object),
  variabilities = NULL,
  nbg = 25
)

\S4method{getAnnotationSynergy}{SummarizedExperiment,MatrixOrmatrix}(
  object,
  annotations,
  background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object),
  variabilities = NULL,
  nbg = 25
)

\S4method{getAnnotationSynergy}{SummarizedExperiment,list}(
  object,
  annotations,
  background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object),
  variabilities = NULL,
  nbg = 25
)

\S4method{getAnnotationSynergy}{MatrixOrmatrix,SummarizedExperiment}(
  object,
  annotations,
  background_peaks,
  expectation = computeExpectations(object),
  variabilities = NULL,
  nbg = 25
)

\S4method{getAnnotationSynergy}{MatrixOrmatrix,MatrixOrmatrix}(
  object,
  annotations,
  background_peaks,
  expectation = computeExpectations(object),
  variabilities = NULL,
  nbg = 25
)

\S4method{getAnnotationSynergy}{MatrixOrmatrix,list}(
  object,
  annotations,
  background_peaks,
  expectation = computeExpectations(object),
  variabilities = NULL,
  nbg = 25
)
}
\arguments{
\item{object}{result from computeDeviations}

\item{annotations}{SummarizedExperiment of annotation matches}

\item{...}{additional arguments}

\item{background_peaks}{optional, matrix of background peaks}

\item{expectation}{optional, expected fraction of reads per peak, as computed
by computeExpectations}

\item{variabilities}{optional, variabilities computed from computeVariability}

\item{nbg}{number of background iterations}
}
\value{
synergy matrix
}
\description{
getAnnotationSynergy
}
\details{
should only be run on small number of motifs/kmers/peaksets 
(very slow!)
}
\section{Methods (by class)}{
\itemize{
\item \code{getAnnotationSynergy(
  object = SummarizedExperiment,
  annotations = SummarizedExperiment
)}: object and annotations are 
SummarizedExperiment

\item \code{getAnnotationSynergy(
  object = SummarizedExperiment,
  annotations = MatrixOrmatrix
)}: object is SummarizedExperiment, 
annotations are Matrix

\item \code{getAnnotationSynergy(object = SummarizedExperiment, annotations = list)}: object is SummarizedExperiment, 
annotations are list

\item \code{getAnnotationSynergy(
  object = MatrixOrmatrix,
  annotations = SummarizedExperiment
)}: object and annotations are 
SummarizedExperiment

\item \code{getAnnotationSynergy(object = MatrixOrmatrix, annotations = MatrixOrmatrix)}: object is SummarizedExperiment, 
annotations are Matrix

\item \code{getAnnotationSynergy(object = MatrixOrmatrix, annotations = list)}: object is SummarizedExperiment, 
annotations are list

}}
