% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{partner_gene_ensembl_id}
\alias{partner_gene_ensembl_id}
\alias{partner_gene_ensembl_id,PartnerGene-method}
\alias{partner_gene_ensembl_id<-}
\alias{partner_gene_ensembl_id<-,PartnerGene-method}
\title{Get the Ensembl ID from a PartnerGene object}
\usage{
partner_gene_ensembl_id(x)

\S4method{partner_gene_ensembl_id}{PartnerGene}(x)

partner_gene_ensembl_id(object) <- value

\S4method{partner_gene_ensembl_id}{PartnerGene}(object) <- value
}
\arguments{
\item{x}{The PartnerGene object you wish to retrieve the Ensembl ID for.}

\item{object}{The PartnerGene object you wish to set a new Ensembl ID for.}

\item{value}{The new Ensembl ID.}
}
\value{
The upstream fusion partner gene Ensembl ID.
}
\description{
This getter retrieves the Ensembl ID from a PartnerGene object

This sets the Ensembl ID of a PartnerGene object.
}
\examples{
# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- fusions[[1]]
# Get the Ensembl ID from the upstream fusion partner gene
partner_gene_ensembl_id(upstream_partner_gene(fusion))

# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- fusions[[1]]
# Set the downstream PartnerGene object to be the same as the upstream
# PartnerGene object
partner_gene_ensembl_id(upstream_partner_gene(fusion)) <- "test"

}
