% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_squid.R
\name{import_squid}
\alias{import_squid}
\title{Import results from a SQUID run into a list of Fusion objects.}
\usage{
import_squid(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the SQUID results.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from a SQUID run into a list of Fusion
objects.
}
\examples{
squidfile <- system.file(
  "extdata",
  "squid_hcc1954_sv.txt",
  package="chimeraviz")
fusions <- import_squid(squidfile, "hg19", 3)
# This should import a list of 3 fusions described in Fusion objects.
}
