% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DelayedAbind.R
\name{saveDelayedObject,DelayedAbind-method}
\alias{saveDelayedObject,DelayedAbind-method}
\title{Saving a DelayedAbind}
\usage{
\S4method{saveDelayedObject}{DelayedAbind}(x, file, name)
}
\arguments{
\item{x}{A \linkS4class{DelayedAbind} object.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of the DelayedAbind.
}
\description{
Save a \linkS4class{DelayedAbind} object.
See the \dQuote{Combining} operation at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
X <- DelayedArray(matrix(runif(100), ncol=20))
Y <- cbind(X, X)
temp <- tempfile(fileext=".h5")
saveDelayed(Y, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
