% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_violin}
\alias{plot_violin}
\title{Plot Violin plot}
\usage{
plot_violin(
  object,
  group_by = "batch",
  plot_vals = NULL,
  features = "NRL",
  experiment = "gene",
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object}

\item{group_by}{Variable to group (color) cells by}

\item{plot_vals}{plot values}

\item{features}{Features to plot}

\item{experiment}{Name of experiment to use, defaults to active experiment}

\item{...}{extra parameters passed to ggplot2}
}
\value{
a violin plot
}
\description{
Plots a Violin plot of a single data (gene expression, metrics, etc.)
grouped by a metadata variable
}
\examples{
data("tiny_sce")
plot_violin(tiny_sce, "Prep.Method", features = "NRL")

}
