\name{plot.DNAcopy}
\alias{plot.DNAcopy}
\title{A function to plot the original data along with the segments
  identified using segment of DNAcopy.}
\description{
  This function takes a DNAcopy  object generated by
  running \code{\link{getSegments}} and then plots the original data
  along with the segments identified. 
}
\usage{
\S3method{plot}{DNAcopy}(x, ..., save = FALSE, layout)
}
\arguments{
  \item{x}{\code{x} is a DNAcopy object
    generated by \code{\link{getSegments}}}
  \item{\dots}{\code{\dots} may contain an optional boolean for save to
    indicate whether to show the plot on the screen (FALSE. Default) or
    return the name of the plot (TRUE) to allow the users to save the
    plot}
  \item{save}{\code{save} a boolean indicating wheather the plot will be
    draw on the screen only (FALSE) or the name of the png file of the
    plot be returned (TRUE)}
  \item{layout}{\code{layout} a numeric vector of two elements defining
    the values used for mfrow of the function par for the layout of
    figures on a plot}
}
\details{
  This function only works with the DNAcopy returned by
  \code{\link{getSegments}}. It will work with the DNAcopy returned by
  segment of the DNAcopy package when the a column containing the probe
  ids is added as the first column of the "data" element of the object.
}
\value{
  This function returns invisible() or the name of the plot depending on
  whether save is set to FALSE of TRUE.
}
\references{The DNAcopy package}
\author{Jianhua Zhang}
\note{The function is a contribution of The Center for Applied Cancer
  Science of Dana-Farber Cancer Institute}
\seealso{\code{\link{getSegments}}}
\examples{
  if(interactive()){
    require("cghMCR")
    data("segData")
    plot(segData)
  }
}
\keyword{hplot}
