% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_CES_score.R
\name{calculate_CES_score}
\alias{calculate_CES_score}
\title{Calculate CES Score from Segmentation}
\usage{
calculate_CES_score(sample_segmentation)
}
\arguments{
\item{sample_segmentation}{Segmentation Dataframe}
}
\value{
Numeric; CES score
}
\description{
Calculate CES Score from Segmentation
}
\examples{
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
### Example PoN
PoN_rdsfile <- system.file("extdata","ex.PoN.rds",package = "cfdnakit")
pon_profiles <- readRDS(PoN_rdsfile)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")

sample_zscore <- get_zscore_profile(sample_profile,pon_profiles)

sample_zscore_segment <- segmentByPSCB(sample_zscore)

calculate_CES_score(sample_zscore_segment)

}
