% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_internal_v3.R
\name{fixMSD}
\alias{fixMSD}
\title{Mean Square Displacement}
\usage{
fixMSD(
  Object,
  Step,
  SlopePlot,
  AllSlopesPlot,
  FurthPlot,
  AllFurthPlot,
  sLAG,
  ffLAG,
  color,
  export,
  ExpName,
  new.fld
)
}
\arguments{
\item{Step}{A numeric value of the number of trajectory steps.}

\item{SlopePlot}{A logical vector that allows generating individual
plots showing the slope of the mean square displacement of the
movement of individual cells. Default is TRUE.}

\item{AllSlopesPlot}{A logical vector that allows generating a plot
showing the slope of the mean square displacement of the movement of
all cells. Default is TRUE.}

\item{FurthPlot}{A logical vector that allows generating individual
plots fitting the Furth formula using generalized regression by the
Nelder–Mead method simplex method per cell. Default is TRUE.}

\item{AllFurthPlot}{A logical vector that allows generating a plot
fitting the Furth formula using generalized regression by the
Nelder–Mead method simplex method for all cells. Default is TRUE.}

\item{sLAG}{A numeric value to be used to get the number of lags
for the slope fitting. Default is 0.25, which represents 25 percent
of the steps.}

\item{ffLAG}{A numeric value to be used to get the number of lags
for the    Furth formula fitting. Default is 0.25, which represents
25 percent of the steps.}

\item{color}{A vector of colors that will be used for the plots}

\item{export}{if `TRUE` (default), exports function output}

\item{ExpName}{String, name of the experiment}

\item{new.fld}{path to the folder where to save files}

\item{object}{\code{CellMig} class object, which is a list
of data frames resulted from the PreProcessing.}
}
\value{
A data frame named "MSDResultsTable".
}
\description{
This function is a part of the MSD function, which
computes the mean square displacements across several sequential
time intervals.
}
\examples{
cellmigRation:::fixMSD(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
\keyword{internal}
