% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_classes.R, R/all_methods_v3.R
\name{CellMig-class}
\alias{CellMig-class}
\alias{CellMig}
\alias{initialize,CellMig-method}
\title{The CellMig Class.}
\usage{
CellMig(..., ExpName = NULL)

\S4method{initialize}{CellMig}(.Object, trajdata)

CellMig(..., ExpName = NULL)
}
\arguments{
\item{...}{arguments to pass to the CellMig constructor}

\item{ExpName}{string, experiment name (optional)}

\item{.Object}{the CellMig object being built}

\item{trajdata}{data frame including trajectory data}
}
\value{
An S4-class object

a CellMig object
}
\description{
The CellMig class represents objects storing all information for
both
random migration (RM) and wound scratch assay (WSA). It comprises
14 slots.
}
\section{Slots}{

\describe{
\item{\code{trajdata}}{The raw trajectory data matrix organized into
four columns: cell ID, X coordinates, Y coordinates and Track
number,
which is the track's path order.}

\item{\code{adjDS}}{A data frame of the trajectory data passed
from the WSAprep function.}

\item{\code{cellpos}}{A binary vector showing on which side of the wound
cells
are located. "0" refers to a cell located above the wound whereas
"1"
refers to a cell located below the wound.}

\item{\code{parE}}{A numeric vector contains estimations for the
imageH, woundH, upperE and lowerE.}

\item{\code{preprocessedDS}}{list object of data frames, each data frame
shows the trajectories of a single cell.}

\item{\code{DRtable}}{A data frame of the results of running the
DiRatio() function.}

\item{\code{MSDtable}}{A data frame of the results of running the MSD()
function.}

\item{\code{PerAanSpeedtable}}{A data frame of the results of running
the PerAndSpeed() function.}

\item{\code{DACtable}}{A data frame of the results of running
the DiAutoCor() function.}

\item{\code{VACtable}}{A data frame of the results of running
the VeAutoCor() function.}

\item{\code{ForMigtable}}{A data frame of the results of running
the ForwardMigration() function.}

\item{\code{FMItable}}{A data frame of the results of running the FMI()
function.}

\item{\code{results}}{A data frame of all the results.}

\item{\code{parCor}}{A data frame for Parameters Correlation.}

\item{\code{meta}}{A list including experiment name, meta data and other
information.}
}}

\examples{
data("TrajectoryDataset")
CellMig(TrajectoryDataset)

}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
