% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getXref-methods.R
\name{getXref,CellBaseR-method}
\alias{getXref,CellBaseR-method}
\alias{getXref}
\title{getXref}
\usage{
\S4method{getXref}{CellBaseR}(object, ids, resource, param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{ids}{a character vector of the ids to be queried, any crossrefereable
 ID, gene names, transcript ids, 
uniprot ids,etc.}

\item{resource}{a character vector to specify the resource to be queried}

\item{param}{a object of class CellBaseParam specifying additional param
for the query}
}
\value{
a dataframe with the results of the query
}
\description{
A method to query cross reference data from Cellbase web services.
}
\details{
This method retrieves cross references for genomic identifiers, eg
ENSEMBL ids, it also provide starts_with service that is useful for
autocomplete services.
}
\examples{
   cb <- CellBaseR()
   res <- getXref(object=cb, ids="ENST00000373644", resource="xref")
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
