% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perplexity.R
\name{plotRPC}
\alias{plotRPC}
\alias{plotRPC,SingleCellExperiment-method}
\alias{plotRPC,celdaList-method}
\title{Visualize perplexity differences of a list of celda models}
\usage{
plotRPC(x, altExpName = "featureSubset", sep = 5, alpha = 0.5)

\S4method{plotRPC}{SingleCellExperiment}(x, altExpName = "featureSubset", sep = 5, alpha = 0.5)

\S4method{plotRPC}{celdaList}(x, sep = 5, alpha = 0.5)
}
\arguments{
\item{x}{Can be one of
\itemize{
 \item A \linkS4class{SingleCellExperiment} object returned from
 \code{celdaGridSearch}, \code{recursiveSplitModule},
 or \code{recursiveSplitCell}. Must contain a list named
 \code{"celda_grid_search"} in \code{metadata(x)}.
 \item celdaList object.}}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{sep}{Numeric. Breaks in the x axis of the resulting plot.}

\item{alpha}{Numeric. Passed to \link{geom_jitter}. Opacity of the points.
Values of alpha range from 0 to 1, with lower values corresponding
to more transparent colors.}
}
\value{
A ggplot plot object showing perplexity differences as a function of
 clustering parameters.
}
\description{
Visualize perplexity differences of every model in a celdaList,
 by unique K/L combinations.
}
\examples{
data(sceCeldaCGGridSearch)
sce <- resamplePerplexity(sceCeldaCGGridSearch)
plotRPC(sce)
data(celdaCGSim, celdaCGGridSearchRes)
## Run various combinations of parameters with 'celdaGridSearch'
celdaCGGridSearchRes <- resamplePerplexity(
  celdaCGSim$counts,
  celdaCGGridSearchRes)
plotRPC(celdaCGGridSearchRes)
}
